#include <algorithm>
#include <cmath>
#include <iostream>
#include <vector>

using namespace std;

struct Move {
    int id;
    long long x;
    long long y;
    long double angle;
};

bool compare(const Move &a, const Move &b) { return a.angle < b.angle; }

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int n;
    cin >> n;
    vector<Move> moves(n);

    for (int i = 0; i < n; i++) {
        Move m;
        m.id = i + 1;
        cin >> m.x >> m.y;
        m.angle = atan2l((long double)m.y, (long double)m.x);
        moves[i] = m;
    }

    sort(moves.begin(), moves.end(), compare);
    moves.reserve(2 * n);
    const long double PI = acosl(-1.0);
    for (int i = 0; i < n; i++) {
        Move m = moves[i];
        m.angle += 2 * PI;
        moves.push_back(m);
    }

    int left = 0, l = 0, r = -1;
    __int128 x = 0, y = 0;
    long double maxDist = -1.0;
    for (int right = 0; right < 2 * n; right++) {
        x += moves[right].x;
        y += moves[right].y;

        while (moves[right].angle - moves[left].angle > PI - 1e-10) {
            x -= moves[left].x;
            y -= moves[left].y;
            left++;
        }

        long double ldx = (long double)x;
        long double ldy = (long double)y;
        long double dist = ldx * ldx + ldy * ldy;
        if (dist > maxDist) {
            maxDist = dist;
            l = left;
            r = right;
        }
    }

    cout << r - l + 1 << endl;
    for (int i = l; i < r; i++) {
        cout << moves[i].id << " ";
    }

    cout << moves[r].id << endl;
    return 0;
}